fastafile=$1
searchfile=$2
outputfile=$3
echo "Executing..."
if grep -q "BLAST" $searchfile; then
	searchtype="blast"
else
	if grep -q "RAPSearch" $searchfile; then
		searchtype="rapsearch"
	fi	
fi
grep ">" $fastafile | cut -d '>' -f 2| cut -d ',' -f 1 > list_seq_names
split -d -l 60000 list_seq_names part_
rm list_seq_names
files_to_analyse=`ls part_*`
case $searchtype in
	blast)
		for inputfile in $files_to_analyse
			do
				bash analyser_blast.sh $inputfile $searchfile &
			done
		wait
		;;
	rapsearch)
		for inputfile in $files_to_analyse
			do
				bash analyser_rapsearch.sh $inputfile $searchfile &
			done
		wait
		;;
esac
cat out_part* > $outputfile
rm out_part_*
rm part_*
echo ""
echo "Done"